SET SQL_SAFE_UPDATES=0;

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REJECT_ADMISSION_RECIPIENTS');

UPDATE `sql_dtprovider`
SET `sqlQuery` = "select T4.id AS ID,
	T1.`code` AS APPLICATION_ID,
	T2.`firstName` AS FIRST_NAME,
	T2.`lastName` AS LAST_NAME,
	T2.`emailId` AS EMAIL_ID,
	T2.`mobileNumber` AS MOBILE_NO,
    T5.displayName AS ACADEMY_LOCATION_NAME,
    T5.academyName AS ACADEMY_NAME,
    T5.locationName AS LOCATION_NAME,
    T5.academyCode AS ACADEMY_ID,
    T1.applicationCreatedOn AS APPLICATION_DATE,
    CONCAT(T7.phoneCountryCode,'-',T7.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T7.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T11.programName AS PROGRAM_NAME,
    T13.batchName AS INTAKE,
    T18.seatName AS SEAT_TYPE,
	ml.`code` AS LANGUAGE_KEY,
        (CASE
        WHEN
            T5.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T5.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
    (CASE
        WHEN
            T5.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T5.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T5.logoUrl)
    END) AS LOGO_URL,
        (CASE
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'APPLIED'
        THEN
            'Applied'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'NOT_APPLIED'
        THEN
            'Not Applied'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'SOLD'
        THEN
            'Sold'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'SUBMITTED'
        THEN
            'Submitted'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'DIRECT_ADMISSION'
        THEN
            'Direct Admission'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'MID_TERM_ADMISSION'
        THEN
            'Mid term admission'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'DIRECT_SUBMISSION_TOKEN_GENERATED'
        THEN
            'Direct submission token generated'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'FORM_SALE_TOKEN_GENERATED'
        THEN
            'Form sale token generated'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'NOT_SUBMITTED'
        THEN
            'Not Submitted'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'ADMISSION_GRANTED'
        THEN
            'Admission granted'
        ELSE ''
    END) AS APPLICATION_STATUS,
    (CASE
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'OFFER_LETTER_ACCEPTED'
        THEN
            'Offer letter accepted'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'OFFER_LETTER_ISSUED'
        THEN
            'Offer letter issued'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'OFFER_LETTER_REJECTED'
        THEN
            'Offer letter rejected'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'OFFER_LETTER_DUE'
        THEN
            'Offer letter due'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'ACTIVE'
        THEN
            'Active'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'ADMITTED'
        THEN
            'Admitted'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'ADMITTED_ON_TRIAL'
        THEN
            'Admitted on trial'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'ADMITTED_ON_PROVISIONAL'
        THEN
            'Admitted on provisional'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER'
        THEN
            'Withdrawn after accepting offer letter'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'PROVISIONAL_OFFER_ISSUED'
        THEN
            'Provisional offer issued'
            WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'PROVISIONAL_OFFER_REJECTED'
        THEN
            'Provisional offer rejected'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'PROVISIONAL_OFFER_DUE'
        THEN
            'Provisional offer due'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'OFFER_EXPIRED'
        THEN
            'Offer Expired'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'PROVISIONAL_OFFER_EXPIRED'
        THEN
            'Provisional Offer Expired'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'ESCALATED'
        THEN
            'Escalated'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'ESCALATED_OFFER_REVIEWED'
        THEN
            'Escalated Offer Reviewed'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'WAITING_LIST'
        THEN
            'Waiting List'  
        ELSE ''
    END) AS OFFER_STATUS,
    T7.websiteURL AS WEBSITE_URL
    from application_program T4
		left outer join
    application T1 on T4.applicationId = T1.id
		left outer join
    applicant_person T2 on T1.applicantPersonId=T2.id
		LEFT OUTER JOIN
    academy_location T5 ON T5.id = T4.academyLocationId
		LEFT OUTER JOIN
    academy_location_addresses T6 ON T6.academyLocationId = T5.id
		LEFT OUTER JOIN
    address T7 ON T7.id = T6.addressId && T7.addressTypeId=10
		LEFT OUTER JOIN
	city T8 ON T8.id = T7.cityId
		LEFT OUTER JOIN
	country T9 ON T9.id = T8.countryId
		LEFT OUTER JOIN
	country_region T10 ON T10.id = T8.countryRegionId
		LEFT OUTER JOIN
	programs T11 ON T11.id = T4.programId		
		LEFT JOIN       
    prog_batch_seat_config T17 on T17.id = T4.progBatchSeatConfigId
    LEFT JOIN
	batches T13 ON T13.programId=T11.id and T13.id = T17.programBatchId
     LEFT JOIN
    seat_types T18 ON T18.id = T17.seatTypeId
     LEFT JOIN
	users T14 ON T14.id=T1.applicationOwner
		LEFT JOIN
    staffs T15 ON T15.userId = T14.id
        LEFT JOIN
    persons T16 ON T16.id = T15.personId
		LEFT JOIN
    multi_language ml ON ml.id = T2.correspondence_language
		LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
    where T4.id in(namedParams)" ,
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
		{
            "id": 2,
            "value": "code",
            "resultKey": "APPLICATION_ID",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "displayName",
            "resultKey": "ACADEMY_LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "batchName",
            "resultKey": "INTAKE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "seatName",
            "resultKey": "SEAT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "APPLICATION_STATUS",
            "resultKey": "APPLICATION_STATUS",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "OFFER_STATUS",
            "resultKey": "OFFER_STATUS",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "applicationCreatedOn",
            "resultKey": "APPLICATION_DATE",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "academyCode",
            "resultKey": "ACADEMY_ID",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 14
        },
		 {
            "id": 16,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 15
        },
		 {
            "id": 17,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 16
        },
		 {
            "id": 18,
            "value": "ACADEMY_LOCATION_PHONE_NO",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 17
        },
		 {
            "id": 19,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 18
        },
        {
            "id": 20,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 19
        }
    ]
}' WHERE (`dataProviderId` = @dtproviderId);

SET SQL_SAFE_UPDATES=1;